@extends('layouts.default')
@section('conteudo')
<div>
    <h5>
        Pagamentos em atraso
        
        <a href="{{url('')}}" class="material-icons float-right" style="font-size: 1.3em; color: #333;">
        keyboard_backspace
        </a>
    </h5>
    <hr>
        
    <!-- <form method="GET" action="{{ url('relatorio/fechamento-caixa') }}">
        <div class="row mb-2">
            <div class="col-6 col-md-4">
                <label for="">Data início: </label>
                <input type="date" name="dtInicio" max="{{ date('Y-m-d') }}" class="form-control">
            </div>
            <div class="col-6 col-md-2">
                <label for="">Hora início: </label>
                <input type="time" name="horaInicio" class="form-control"> 
            </div>
            <div class="col-6 col-md-4">
                <label for="">Data término: </label>
                <input type="date" name="dtTermino" max="{{ date('Y-m-d') }}" class="form-control"> 
            </div>
            <div class="col-6 col-md-2">
                <label for="">Hora término: </label>
                <input type="time" name="horaTermino" class="form-control"> 
            </div>
        </div>
        <div class="row">
            <div class="col-md-12">
                <button type="submit" class="btn btn-primary btn-block btn-parque"><i class="material-icons icone">search</i> Buscar</button>
            </div>
        </div>
    </form>
    <br> -->

    <div class="row">
        <div class="col-md-12">
            @if($clientes)
                <?php $total = 0; ?>
                <table class="table table-hover table-sm" width="100%">
                    <thead>
                        <tr class="btn-parque">
                            <th>Cliente</th>
                            <th>Dependentes</th>
                            <th>Próximo Vencimento</th>
                            <th>Situação</th>
                            <th>Valor</th>
                        </tr>
                    </thead>
                    @foreach($clientes as $cliente)
                        <tr>
                            <td>{{mb_strtoupper($cliente->nome)}}</td>
                            <td>{{$cliente->dependentes}}</td>
                            <td>{!!$cliente->dtUltimoVencimento ?? '<span style="color: red">Nenhum pagamento</span>'!!}</td>
                            <td>{!!$cliente->atraso ? '<span class="badge badge-danger">Em atraso</span>' : '<span class="badge badge-success">Em dia</span>'!!}</td>
                            <td>{{number_format($cliente->valor, 2, ',', '.')}}</td>
                        </tr>
                        <?php $total += $cliente->valor; ?>
                    @endforeach    
                </table>

                <div class="float-right" style="font-size: 1.5em;">
                    <b>Total R$ {{ number_format($total, 2, ',', '.') }}</b>
                </div>
            @else
                <div class="alert alert-info mt-3">Nenhum registro encontrado</div>
            @endif
        </div>
    </div>
</div>
@endsection

@section('scripts')

@endsection

